#include <QApplication>
#include <QTranslator>
#include <QDebug>
#include "mainwindowimpl.h"
#include "connection.h"
#include <QPlastiqueStyle>
#include "definitionen.h"

//
int main(int argc, char ** argv)
{
	
	QApplication app( argc, argv );

	//Plastic style setzten
	if (!NATIV_STYLE){
		app.setStyle("plastique");
	}

	// Übersetztung der QT widgets
	// Common qt widgets
	QTranslator translatorQt;
	//translatorQt.load("qt_de.qm", "./languages/");
	translatorQt.load(":/sprachen/qt_de.qm");
	app.installTranslator(&translatorQt);

	//Wenn die Datenbanksicherung noch vorhanden ist ist bei einem vorherigen start
	//etwas schiefgelaufen, also erst die Sicherung wieder zurücksichern
	RestorDatenbank();

	//Mit Datenbank verbinden
	if (!ErstelleVerbindung()) {
		return 1;
	}
	
	//Das verbinden/Updaten der Datenbank war erfolgreich somit kann die Sicherungsdatei
	//gelöscht werden
	RemoveDatenbanksicherung();
	
	MainWindowImpl win;
	win.show(); 

	app.connect( &app, SIGNAL( lastWindowClosed() ), &app, SLOT( quit() ) );
	return app.exec();
}
